import unittest
import unittest.mock

from chat.client import ChatClient

from .fakeserver import FakeServer


class TestChatMessageExchange(unittest.TestCase):
    def setUp(self):
        self.fakeserver = unittest.mock.patch("multiprocessing.managers.listener_client", new={
            "pickle": (None, FakeServer())
        })
        self.fakeserver.start()

    def tearDown(self):
        self.fakeserver.stop()

    def test_exchange_with_server(self):
        c1 = ChatClient("User1")
        c2 = ChatClient("User2")

        c1.send_message("przykładowa wiadomość")

        assert c2.fetch_messages()[-1] == "User1: przykładowa wiadomość"

    def test_many_users(self):
        firstUser = ChatClient("Jan Kowalski")

        for uid in range(5):
            moreuser = ChatClient(f"Użytkownik {uid}")
            moreuser.send_message("Witaj!")

        messages = firstUser.fetch_messages()
        assert len(messages) == 5

    def test_multiple_readers(self):
        user1 = ChatClient("Jan Kowalski")
        user2 = ChatClient("Użytkownik 2")
        user3 = ChatClient("Użytkownik 3")

        user1.send_message("Cześć wszystkim")
        user2.send_message("Witaj, świecie!")
        user3.send_message("Cześć")

        user1_messages = user1.fetch_messages()
        user2_messages = user2.fetch_messages()

        self.assertEqual(user1_messages, user2_messages)